package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TareaDaoImpl;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.Tramite;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteAperturasDaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TareaCustomDaoImpl extends TareaDaoImpl implements TareaCustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_090 IDTAREA090, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089 FROM VTAREAS_TRAMITES t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Tarea> rwMap = new RowMapper<Tarea>() {
		public Tarea mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Tarea tram = new Tarea(resultSet.getLong("IDTAREA090"), null,
					resultSet.getString("TASKID090"),
					resultSet.getString("DESCRIPCIONES090"),
					resultSet.getString("DESCRIPCIONEU090"),
					resultSet.getBoolean("ESINICIAL090"),
					resultSet.getString("TIPO090"));

			tram.setTramite(new Tramite(resultSet.getLong("IDTRAMITE090"),
					resultSet.getString("PROCEDUREID089"),
					resultSet.getString("PROCEEDINGID089"),
					resultSet.getString("DESCRIPCIONES089"),
					resultSet.getString("DESCRIPCIONEU089")));

			return tram;
		}
	};

	/**
	 * Finds a single row in the Tarea table.
	 * 
	 *  tarea
	 *            Tarea
	 *  Tarea
	 *
	 * @param tarea the tarea
	 * @return the tarea
	 */
	@Transactional(readOnly = true)
	public Tarea vfind(Tarea tarea) {
		StringBuilder query = new StringBuilder(
				TareaCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_090 = ? ");

		List<Tarea> tareasList = this.getJdbcTemplate().query(query.toString(),
				this.rwMap, tarea.getIdTarea090());
		return (Tarea) DataAccessUtils.uniqueResult(tareasList);
	}

	/**
	 * Finds a single row in the Tarea table.
	 * 
	 *  taskId
	 *            String
	 *  procedureId
	 *            String
	 *  Tarea
	 *
	 * @param taskId the task id
	 * @param procedureId the procedure id
	 * @return the tarea
	 */
	@Transactional(readOnly = true)
	public Tarea findByTaskIdProcedureId(String taskId, String procedureId) {
		StringBuilder query = new StringBuilder(
				TareaCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.TASK_ID_090 = ? AND t1.PROCEDURE_ID_089 = ? ");

		List<Tarea> tareasList = this.getJdbcTemplate().query(query.toString(),
				this.rwMap, taskId, procedureId);
		return (Tarea) DataAccessUtils.uniqueResult(tareasList);
	}

	/**
	 * Finds a list of rows in the Tarea table.
	 * 
	 *  tarea
	 *            Tarea
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Tarea>
	 *
	 * @param tarea the tarea
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Tarea> vfindAll(Tarea tarea,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TareaCustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tarea);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Tarea>) this.getJdbcTemplate().query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0490s00 entity
	 * 
	 *  ab0490s00
	 *            Ab0490s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tarea ab0490s00) {

		StringBuilder where = new StringBuilder(
				TareaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0490s00 != null && ab0490s00.getIdTarea090() != null) {
			where.append(" AND t1.ID_TAREA_090 = ?");
			params.add(ab0490s00.getIdTarea090());
		}
		if (ab0490s00 != null && ab0490s00.getTramite() != null
				&& ab0490s00.getTramite().getIdTramite089() != null) {
			where.append(" AND t1.ID_TRAMITE_090 = ?");
			params.add(ab0490s00.getTramite().getIdTramite089());
		}
		if (ab0490s00 != null && ab0490s00.getTaskId090() != null) {
			where.append(" AND t1.TASK_ID_090 = ?");
			params.add(ab0490s00.getTaskId090());
		}
		if (ab0490s00 != null && ab0490s00.getDescripcionEs090() != null) {
			where.append(" AND t1.DESCRIPCION_ES_090 = ?");
			params.add(ab0490s00.getDescripcionEs090());
		}
		if (ab0490s00 != null && ab0490s00.getDescripcionEu090() != null) {
			where.append(" AND t1.DESCRIPCION_EU_090 = ?");
			params.add(ab0490s00.getDescripcionEu090());
		}
		if (ab0490s00 != null && ab0490s00.getEsInicial090() != null) {
			where.append(" AND t1.ES_INICIAL_090 = ?");
			params.add(ab0490s00.getEsInicial090());
		}
		if (ab0490s00 != null && ab0490s00.getTipo090() != null) {
			where.append(" AND t1.TIPO_090 = ?");
			params.add(ab0490s00.getTipo090());
		}

		if (ab0490s00 != null && ab0490s00.getTramite() != null
				&& ab0490s00.getTramite().getProcedureId089() != null) {
			where.append(" AND t1.PROCEDURE_ID_089 = ?");
			params.add(ab0490s00.getTramite().getProcedureId089());
		}
		if (ab0490s00 != null && ab0490s00.getTramite() != null
				&& ab0490s00.getTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(ab0490s00.getTramite().getProceedingId089());
		}
		if (ab0490s00 != null && ab0490s00.getTramite() != null
				&& ab0490s00.getTramite().getDescripcionEs089() != null) {
			where.append(" AND t1.DESCRIPCION_ES_089 = ?");
			params.add(ab0490s00.getTramite().getDescripcionEs089());
		}
		if (ab0490s00 != null && ab0490s00.getTramite() != null
				&& ab0490s00.getTramite().getDescripcionEu089() != null) {
			where.append(" AND t1.DESCRIPCION_EU_089 = ?");
			params.add(ab0490s00.getTramite().getDescripcionEu089());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
